/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.step;

import com.quantumdata.sct.dao.vo.InputStepVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.engine.EngineException;
import com.quantumdata.sct.engine.IEngineContext;
import com.quantumdata.sct.engine.step.StepEngine;
import com.quantumdata.sct.engine.step.StepEngineContext;
import com.quantumdata.sct.gui.common.SCTCheckBox;
import com.quantumdata.sct.gui.wizard.InputSelectionPanel;
import java.util.Properties;
import javax.swing.JPanel;

public class InputStepEngine
extends StepEngine {
    private InputSelectionPanel selectionPanel;
    private int errorStatus = 0;

    public InputStepEngine(InputStepVO inputStepVO) {
        super(inputStepVO);
    }

    public int getError() {
        return this.errorStatus;
    }

    public boolean getStatus() {
        boolean bl = false;
        try {
            InputStepVO inputStepVO = (InputStepVO)this.stepVO;
            if (inputStepVO.getParameters().isEmpty()) {
                return true;
            }
            ParameterVO parameterVO = inputStepVO.getParameter(0);
            String string = this.selectionPanel.getTextValue();
            if (string.length() == 0) {
                return true;
            }
            String string2 = parameterVO.getType();
            if (string2 == null) {
                return false;
            }
            if (string2.equalsIgnoreCase("TEXT")) {
                String string3 = parameterVO.getValue();
                bl = string == null && string3 == null ? true : (string == null || string3 == null ? false : string.equals(string3));
            } else if (string2.equalsIgnoreCase("FLOAT") || string2.equalsIgnoreCase("INTEGER")) {
                float f = Float.parseFloat(string);
                if (f == Float.NaN) {
                    this.errorStatus = 20005;
                }
                float f2 = Float.parseFloat(parameterVO.getCapLow());
                float f3 = Float.parseFloat(parameterVO.getCapHigh());
                bl = f > f2 && f < f3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof NumberFormatException) {
                this.errorStatus = 20005;
                return true;
            }
            exception.printStackTrace();
        }
        return bl;
    }

    public JPanel getDisplay(Properties properties) {
        int n = 0;
        SCTCheckBox sCTCheckBox = null;
        if (properties.getProperty("StepCountValue") != null) {
            try {
                String string = properties.getProperty("StepCountValue");
                n = Integer.parseInt(string);
                sCTCheckBox = (SCTCheckBox)properties.get("ResultCheckBox");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.selectionPanel = new InputSelectionPanel((InputStepVO)this.stepVO, n, sCTCheckBox);
        return this.selectionPanel;
    }

    public int execute(IEngineContext iEngineContext) throws EngineException {
        super.execute(iEngineContext);
        String string = this.selectionPanel.getTextValue();
        boolean bl = false;
        if (string.length() == 0 || this.errorStatus != 0) {
            bl = true;
        }
        this.errorStatus = 0;
        if (bl) {
            return 1;
        }
        if (!this.stepVO.getParameters().isEmpty()) {
            ParameterVO parameterVO = this.stepVO.getParameter(0);
            parameterVO.setValue(string);
            TestStepResultVO testStepResultVO = ((StepEngineContext)iEngineContext).getStepResultVO();
            if (testStepResultVO != null) {
                testStepResultVO.getParameters().add(parameterVO);
            }
        }
        return 0;
    }

    public boolean isUserStep() {
        return true;
    }
}

